var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
var reg_foglio = /^\d{1,4}$/;
var reg_particella = /^[a-zA-Z0-9]{1,5}(, ?[a-zA-Z0-9]{1,5})*$/;
///^\d{1,5}(,\d{1,5})*$/;
var reg_rea = /^[A-Z]{2} ?\d{1,7}$/;
var reg_inps = /^\d{10}$/;


$(document).on("input", "#numero_localizzazioni_investimenti", function () {
  var numero_di_localizzazioni = $(this).val()*1;
  if (numero_di_localizzazioni.length == 0) {
      $("#numero_localizzazioni_investimenti").addClass("is-invalid");
      $("#errore_numero_localizzazioni_investimenti").addClass("invalid-feedback");
      $("#errore_numero_localizzazioni_investimenti").text("Inserire il numero di localizzazioni investimenti.");
  }
  else 
  {
    if(numero_di_localizzazioni < 1){
      $("#numero_localizzazioni_investimenti").addClass("is-invalid");
      $("#errore_numero_localizzazioni_investimenti").addClass("invalid-feedback");
      $("#errore_numero_localizzazioni_investimenti").text("Il numero di localizzazioni investimenti deve essere maggiore di 1.");
    }else{
      var numero_localizzazioni_precedenti = $(this).attr("data-numero-localizzazioni-prev");
      $("#numero_localizzazioni_investimenti").removeClass("is-invalid");
      $("#errore_numero_localizzazioni_investimenti").removeClass("invalid-feedback");
      $("#errore_numero_localizzazioni_investimenti").text("");
      if(numero_localizzazioni_precedenti > numero_di_localizzazioni){
        rimuovi_localizzazione_investimento(numero_di_localizzazioni, numero_localizzazioni_precedenti);
      }
      else{
        crea_localizzazione_investimento(numero_di_localizzazioni, numero_localizzazioni_precedenti);
      }
    }
  }
});

$(document).on("change", "#provincia-localizzazione", function () {
  var provinciaLocalizzazione = $(this).val();
  $("[id^=comune-localizzazione]").each(function () {
      $(this).html("").prop("disabled", true);
  });

  if (provinciaLocalizzazione.length == 0) {
    $("#provincia-localizzazione").addClass("is-invalid");
    $("#errore_provincia_localizzazione").addClass("invalid-feedback");
    $("#errore_provincia_localizzazione").text("Provincia di localizzazione obbligatoria.");  
    $("[id^=comune-localizzazione]").addClass("is-invalid");
    $("[id^=errore_comune_localizzazione]").addClass("invalid-feedback")
    $("[id^=errore_comune_localizzazione]").text("Seleziona prima la provincia.");
  } else {
      $("#provincia-localizzazione").removeClass("is-invalid");
      $("#errore_provincia_localizzazione").removeClass("invalid-feedback")
      $("#errore_provincia_localizzazione").text("");

      $("[id^=comune-localizzazione]").prop("disabled", false);
      $("[id^=comune-localizzazione]").removeClass("is-invalid");
      $("[id^=errore_comune_localizzazione]").removeClass("invalid-feedback");
      $("[id^=errore_comune_localizzazione]").text("");
      $("[id^=comune-localizzazione]").html(appendi_select_comuni(provinciaLocalizzazione));
  }
});

$(document).on("change", "[id^=comune-localizzazione]", function () {
  var id = $(this).attr("id");
  var suffix = id.substring("comune-localizzazione".length);
  var comuneLocalizzazione = $(this).val();
  var erroreId = "#errore_comune_localizzazione" + suffix;

  if (comuneLocalizzazione.length == 0) {
    $(this).addClass("is-invalid");
    $(erroreId).addClass("invalid-feedback")
    $(erroreId).text("Comune di localizzazione obbligatorio.");
  } else {
    $(this).removeClass("is-invalid");
    $(erroreId).removeClass("invalid-feedback")
    $(erroreId).text("");
  }
});

$(document).on("input", "[id^=foglio]", function () {
  var id = $(this).attr("id");
  var suffix = id.substring("foglio".length);
  var foglio = $(this).val();
  var erroreId = "#errore_foglio" + suffix;


  if (foglio.length == 0) {
      $(this).addClass("is-invalid");
      $(erroreId).addClass("invalid-feedback");
      $(erroreId).text("Foglio di riferimento dell'immobile obbligatorio.");
  } else if (!reg_foglio.test(foglio)){
      $(this).addClass("is-invalid");
      $(erroreId).addClass("invalid-feedback");
      $(erroreId).text("Foglio di riferimento non valido.");
  } else {
      $(this).removeClass("is-invalid");
      $(erroreId).removeClass("invalid-feedback");
      $(erroreId).text("");
  }
});

$(document).on("input", "[id^=particella]", function () {
  var id = $(this).attr("id");
  var suffix = id.substring("particella".length);
  var particella = $(this).val();
  var erroreId = "#errore_particella" + suffix;

  if (particella.length == 0) {
      $(this).addClass("is-invalid");
      $(erroreId).addClass("invalid-feedback");
      $(erroreId).text("Particella di riferimento dell'immobile obbligatoria.");
  } else if (!reg_particella.test(particella)){
      $(this).addClass("is-invalid");
      $(erroreId).addClass("invalid-feedback");
      $(erroreId).text("Particella di riferimento non valida.");
  } else {
      $(this).removeClass("is-invalid");
      $(erroreId).removeClass("invalid-feedback");
      $(erroreId).text("");
  }
});


function appendi_select_comuni(provincia){
    var provincia = provincia.toLowerCase();
    var option_ag  =       `<option value="Agrigento">Agrigento</option>
                            <option value="Alessandria della Rocca">Alessandria della Rocca</option>
                            <option value="Aragona">Aragona</option>
                            <option value="Bivona">Bivona</option>
                            <option value="Burgio">Burgio</option>
                            <option value="Calamonaci">Calamonaci</option>
                            <option value="Caltabellotta">Caltabellotta</option>
                            <option value="Camastra">Camastra</option>
                            <option value="Cammarata">Cammarata</option>
                            <option value="Campobello di Licata">Campobello di Licata</option>
                            <option value="Canicattì">Canicattì</option>
                            <option value="Casteltermini">Casteltermini</option>
                            <option value="Castrofilippo">Castrofilippo</option>
                            <option value="Cattolica Eraclea">Cattolica Eraclea</option>
                            <option value="Cianciana">Cianciana</option>
                            <option value="Comitini">Comitini</option>
                            <option value="Favara">Favara</option>
                            <option value="Grotte">Grotte</option>
                            <option value="Joppolo Giancaxio">Joppolo Giancaxio</option>
                            <option value="Lampedusa e Linosa">Lampedusa e Linosa</option>
                            <option value="Licata">Licata</option>
                            <option value="Lucca Sicula">Lucca Sicula</option>
                            <option value="Menfi">Menfi</option>
                            <option value="Montallegro">Montallegro</option>
                            <option value="Montevago">Montevago</option>
                            <option value="Naro">Naro</option>
                            <option value="Palma di Montechiaro">Palma di Montechiaro</option>
                            <option value="Porto Empedocle">Porto Empedocle</option>
                            <option value="Racalmuto">Racalmuto</option>
                            <option value="Raffadali">Raffadali</option>
                            <option value="Ravanusa">Ravanusa</option>
                            <option value="Realmonte">Realmonte</option>
                            <option value="Ribera">Ribera</option>
                            <option value="Sambuca di Sicilia">Sambuca di Sicilia</option>
                            <option value="San Biagio Platani">San Biagio Platani</option>
                            <option value="San Giovanni Gemini">San Giovanni Gemini</option>
                            <option value="Santa Elisabetta">Santa Elisabetta</option>
                            <option value="Santa Margherita di Belice">Santa Margherita di Belice</option>
                            <option value="Sant'Angelo Muxaro">Sant'Angelo Muxaro</option>
                            <option value="Santo Stefano Quisquina">Santo Stefano Quisquina</option>
                            <option value="Sciacca">Sciacca</option>
                            <option value="Siculiana">Siculiana</option>
                            <option value="Villafranca Sicula">Villafranca Sicula</option>`;
    var option_cl  =       `<option value="Acquaviva Platani">Acquaviva Platani</option>
                            <option value="Bompensiere">Bompensiere</option>
                            <option value="Butera">Butera</option>
                            <option value="Caltanissetta">Caltanissetta</option>
                            <option value="Campofranco">Campofranco</option>
                            <option value="Delia">Delia</option>
                            <option value="Gela">Gela</option>
                            <option value="Marianopoli">Marianopoli</option>
                            <option value="Mazzarino">Mazzarino</option>
                            <option value="Milena">Milena</option>
                            <option value="Montedoro">Montedoro</option>
                            <option value="Mussomeli">Mussomeli</option>
                            <option value="Niscemi">Niscemi</option>
                            <option value="Resuttano">Resuttano</option>
                            <option value="Riesi">Riesi</option>
                            <option value="San Cataldo">San Cataldo</option>
                            <option value="Santa Caterina Villarmosa">Santa Caterina Villarmosa</option>
                            <option value="Serradifalco">Serradifalco</option>
                            <option value="Sommatino">Sommatino</option>
                            <option value="Sutera">Sutera</option>
                            <option value="Vallelunga Pratameno">Vallelunga Pratameno</option>
                            <option value="Villalba">Villalba</option>`;
    var option_ct   =      `<option value="Aci Bonaccorsi">Aci Bonaccorsi</option>
                            <option value="Aci Castello">Aci Castello</option>
                            <option value="Aci Catena">Aci Catena</option>
                            <option value="Aci Sant'Antonio">Aci Sant'Antonio</option>
                            <option value="Acireale">Acireale</option>
                            <option value="Adrano">Adrano</option>
                            <option value="Belpasso">Belpasso</option>
                            <option value="Biancavilla">Biancavilla</option>
                            <option value="Bronte">Bronte</option>
                            <option value="Calatabiano">Calatabiano</option>
                            <option value="Caltagirone">Caltagirone</option>
                            <option value="Camporotondo Etneo">Camporotondo Etneo</option>
                            <option value="Castel di Iudica">Castel di Iudica</option>
                            <option value="Castiglione di Sicilia">Castiglione di Sicilia</option>
                            <option value="Catania">Catania</option>
                            <option value="Fiumefreddo di Sicilia">Fiumefreddo di Sicilia</option>
                            <option value="Giarre">Giarre</option>
                            <option value="Grammichele">Grammichele</option>
                            <option value="Gravina di Catania">Gravina di Catania</option>
                            <option value="Licodia Eubea">Licodia Eubea</option>
                            <option value="Linguaglossa">Linguaglossa</option>
                            <option value="Maletto">Maletto</option>
                            <option value="Maniace">Maniace</option>
                            <option value="Mascali">Mascali</option>
                            <option value="Mascalucia">Mascalucia</option>
                            <option value="Mazzarrone">Mazzarrone</option>
                            <option value="Militello in Val di Catania">Militello in Val di Catania</option>
                            <option value="Milo">Milo</option>
                            <option value="Mineo">Mineo</option>
                            <option value="Mirabella Imbaccari">Mirabella Imbaccari</option>
                            <option value="Misterbianco">Misterbianco</option>
                            <option value="Motta Sant'Anastasia">Motta Sant'Anastasia</option>
                            <option value="Nicolosi">Nicolosi</option>
                            <option value="Palagonia">Palagonia</option>
                            <option value="Paternò">Paternò</option>
                            <option value="Pedara">Pedara</option>
                            <option value="Piedimonte Etneo">Piedimonte Etneo</option>
                            <option value="Raddusa">Raddusa</option>
                            <option value="Ragalna">Ragalna</option>
                            <option value="Ramacca">Ramacca</option>
                            <option value="Randazzo">Randazzo</option>
                            <option value="Riposto">Riposto</option>
                            <option value="San Cono">San Cono</option>
                            <option value="San Giovanni la Punta">San Giovanni la Punta</option>
                            <option value="San Gregorio di Catania">San Gregorio di Catania</option>
                            <option value="San Michele di Ganzaria">San Michele di Ganzaria</option>
                            <option value="San Pietro Clarenza">San Pietro Clarenza</option>
                            <option value="Sant'Agata li Battiati">Sant'Agata li Battiati</option>
                            <option value="Sant'Alfio">Sant'Alfio</option>
                            <option value="Santa Maria di Licodia">Santa Maria di Licodia</option>
                            <option value="Santa Venerina">Santa Venerina</option>
                            <option value="Scordia">Scordia</option>
                            <option value="Trecastagni">Trecastagni</option>
                            <option value="Tremestieri Etneo">Tremestieri Etneo</option>
                            <option value="Valverde">Valverde</option>
                            <option value="Viagrande">Viagrande</option>
                            <option value="Vizzini">Vizzini</option>
                            <option value="Zafferana Etnea">Zafferana Etnea</option>`;
    var option_en   =      `<option value="Agira">Agira</option>
                            <option value="Aidone">Aidone</option>
                            <option value="Assoro">Assoro</option>
                            <option value="Barrafranca">Barrafranca</option>
                            <option value="Calascibetta">Calascibetta</option>
                            <option value="Catenanuova">Catenanuova</option>
                            <option value="Centuripe">Centuripe</option>
                            <option value="Cerami">Cerami</option>
                            <option value="Enna">Enna</option>
                            <option value="Gagliano Castelferrato">Gagliano Castelferrato</option>
                            <option value="Leonforte">Leonforte</option>
                            <option value="Nicosia">Nicosia</option>
                            <option value="Nissoria">Nissoria</option>
                            <option value="Piazza Armerina">Piazza Armerina</option>
                            <option value="Pietraperzia">Pietraperzia</option>
                            <option value="Regalbuto">Regalbuto</option>
                            <option value="Sperlinga">Sperlinga</option>
                            <option value="Troina">Troina</option>
                            <option value="Valguarnera Caropepe">Valguarnera Caropepe</option>
                            <option value="Villarosa">Villarosa</option>`;
    var option_me   =      `<option value="Acquedolci">Acquedolci</option>
                            <option value="Alcara Li Fusi">Alcara Li Fusi</option>
                            <option value="Alì">Alì</option>
                            <option value="Alì Terme">Alì Terme</option>
                            <option value="Antillo">Antillo</option>
                            <option value="Barcellona Pozzo di Gotto">Barcellona Pozzo di Gotto</option>
                            <option value="Basicò">Basicò</option>
                            <option value="Brolo">Brolo</option>
                            <option value="Capizzi">Capizzi</option>
                            <option value="Capo d'Orlando">Capo d'Orlando</option>
                            <option value="Capri Leone">Capri Leone</option>
                            <option value="Caronia">Caronia</option>
                            <option value="Casalvecchio Siculo">Casalvecchio Siculo</option>
                            <option value="Castel di Lucio">Castel di Lucio</option>
                            <option value="Castell'Umberto">Castell'Umberto</option>
                            <option value="Castelmola">Castelmola</option>
                            <option value="Castroreale">Castroreale</option>
                            <option value="Cesarò">Cesarò</option>
                            <option value="Condrò">Condrò</option>
                            <option value="Falcone">Falcone</option>
                            <option value="Ficarra">Ficarra</option>
                            <option value="Fiumedinisi">Fiumedinisi</option>
                            <option value="Floresta">Floresta</option>
                            <option value="Fondachelli-Fantina">Fondachelli-Fantina</option>
                            <option value="Forza d'Agrò">Forza d'Agrò</option>
                            <option value="Francavilla di Sicilia">Francavilla di Sicilia</option>
                            <option value="Frazzanò">Frazzanò</option>
                            <option value="Furci Siculo">Furci Siculo</option>
                            <option value="Furnari">Furnari</option>
                            <option value="Gaggi">Gaggi</option>
                            <option value="Galati Mamertino">Galati Mamertino</option>
                            <option value="Gallodoro">Gallodoro</option>
                            <option value="Giardini Naxos">Giardini Naxos</option>
                            <option value="Gioiosa Marea">Gioiosa Marea</option>
                            <option value="Graniti">Graniti</option>
                            <option value="Gualtieri Sicaminò">Gualtieri Sicaminò</option>
                            <option value="Itala">Itala</option>
                            <option value="Leni">Leni</option>
                            <option value="Letojanni">Letojanni</option>
                            <option value="Librizzi">Librizzi</option>
                            <option value="Limina">Limina</option>
                            <option value="Lipari">Lipari</option>
                            <option value="Longi">Longi</option>
                            <option value="Malfa">Malfa</option>
                            <option value="Malvagna">Malvagna</option>
                            <option value="Mandanici">Mandanici</option>
                            <option value="Mazzarrà Sant'Andrea">Mazzarrà Sant'Andrea</option>
                            <option value="Merì">Merì</option>
                            <option value="Messina">Messina</option>
                            <option value="Milazzo">Milazzo</option>
                            <option value="Militello Rosmarino">Militello Rosmarino</option>
                            <option value="Mirto">Mirto</option>
                            <option value="Mistretta">Mistretta</option>
                            <option value="Moio Alcantara">Moio Alcantara</option>
                            <option value="Monforte San Giorgio">Monforte San Giorgio</option>
                            <option value="Mongiuffi Melia">Mongiuffi Melia</option>
                            <option value="Montagnareale">Montagnareale</option>
                            <option value="Montalbano Elicona">Montalbano Elicona</option>
                            <option value="Motta Camastra">Motta Camastra</option>
                            <option value="Motta d'Affermo">Motta d'Affermo</option>
                            <option value="Naso">Naso</option>
                            <option value="Nizza di Sicilia">Nizza di Sicilia</option>
                            <option value="Novara di Sicilia">Novara di Sicilia</option>
                            <option value="Oliveri">Oliveri</option>
                            <option value="Pace del Mela">Pace del Mela</option>
                            <option value="Pagliara">Pagliara</option>
                            <option value="Patti">Patti</option>
                            <option value="Pettineo">Pettineo</option>
                            <option value="Piraino">Piraino</option>
                            <option value="Raccuja">Raccuja</option>
                            <option value="Reitano">Reitano</option>
                            <option value="Roccafiorita">Roccafiorita</option>
                            <option value="Roccalumera">Roccalumera</option>
                            <option value="Roccavaldina">Roccavaldina</option>
                            <option value="Roccella Valdemone">Roccella Valdemone</option>
                            <option value="Rodì Milici">Rodì Milici</option>
                            <option value="Rometta">Rometta</option>
                            <option value="San Filippo del Mela">San Filippo del Mela</option>
                            <option value="San Fratello">San Fratello</option>
                            <option value="San Marco d'Alunzio">San Marco d'Alunzio</option>
                            <option value="San Pier Niceto">San Pier Niceto</option>
                            <option value="San Piero Patti">San Piero Patti</option>
                            <option value="San Salvatore di Fitalia">San Salvatore di Fitalia</option>
                            <option value="San Teodoro">San Teodoro</option>
                            <option value="Sant'Agata di Militello">Sant'Agata di Militello</option>
                            <option value="Sant'Alessio Siculo">Sant'Alessio Siculo</option>
                            <option value="Sant'Angelo di Brolo">Sant'Angelo di Brolo</option>
                            <option value="Santa Domenica Vittoria">Santa Domenica Vittoria</option>
                            <option value="Santa Lucia del Mela">Santa Lucia del Mela</option>
                            <option value="Santa Marina Salina">Santa Marina Salina</option>
                            <option value="Santa Teresa di Riva">Santa Teresa di Riva</option>
                            <option value="Santo Stefano di Camastra">Santo Stefano di Camastra</option>
                            <option value="Saponara">Saponara</option>
                            <option value="Savoca">Savoca</option>
                            <option value="Scaletta Zanclea">Scaletta Zanclea</option>
                            <option value="Sinagra">Sinagra</option>
                            <option value="Spadafora">Spadafora</option>
                            <option value="Taormina">Taormina</option>
                            <option value="Terme Vigliatore">Terme Vigliatore</option>
                            <option value="Torregrotta">Torregrotta</option>
                            <option value="Torrenova">Torrenova</option>
                            <option value="Tortorici">Tortorici</option>
                            <option value="Tripi">Tripi</option>
                            <option value="Tusa">Tusa</option>
                            <option value="Ucria">Ucria</option>
                            <option value="Valdina">Valdina</option>
                            <option value="Venetico">Venetico</option>
                            <option value="Villafranca Tirrena">Villafranca Tirrena</option>`;
    var option_pa   =      `<option value="Alia">Alia</option>
                            <option value="Alimena">Alimena</option>
                            <option value="Aliminusa">Aliminusa</option>
                            <option value="Altavilla Milicia">Altavilla Milicia</option>
                            <option value="Altofonte">Altofonte</option>
                            <option value="Bagheria">Bagheria</option>
                            <option value="Balestrate">Balestrate</option>
                            <option value="Baucina">Baucina</option>
                            <option value="Belmonte Mezzagno">Belmonte Mezzagno</option>
                            <option value="Blufi">Blufi</option>
                            <option value="Bisacquino">Bisacquino</option>
                            <option value="Bolognetta">Bolognetta</option>
                            <option value="Bompietro">Bompietro</option>
                            <option value="Borgetto">Borgetto</option>
                            <option value="Caccamo">Caccamo</option>
                            <option value="Caltavuturo">Caltavuturo</option>
                            <option value="Campofelice di Fitalia">Campofelice di Fitalia</option>
                            <option value="Campofelice di Roccella">Campofelice di Roccella</option>
                            <option value="Campofiorito">Campofiorito</option>
                            <option value="Camporeale">Camporeale</option>
                            <option value="Capaci">Capaci</option>
                            <option value="Carini">Carini</option>
                            <option value="Castelbuono">Castelbuono</option>
                            <option value="Casteldaccia">Casteldaccia</option>
                            <option value="Castellana Sicula">Castellana Sicula</option>
                            <option value="Castronovo di Sicilia">Castronovo di Sicilia</option>
                            <option value="Cefalà Diana">Cefalà Diana</option>
                            <option value="Cefalù">Cefalù</option>
                            <option value="Cerda">Cerda</option>
                            <option value="Chiusa Sclafani">Chiusa Sclafani</option>
                            <option value="Ciminna">Ciminna</option>
                            <option value="Cinisi">Cinisi</option>
                            <option value="Collesano">Collesano</option>
                            <option value="Contessa Entellina">Contessa Entellina</option>
                            <option value="Corleone">Corleone</option>
                            <option value="Ficarazzi">Ficarazzi</option>
                            <option value="Gangi">Gangi</option>
                            <option value="Geraci Siculo">Geraci Siculo</option>
                            <option value="Giardinello">Giardinello</option>
                            <option value="Giuliana">Giuliana</option>
                            <option value="Godrano">Godrano</option>
                            <option value="Gratteri">Gratteri</option>
                            <option value="Isnello">Isnello</option>
                            <option value="Isola delle Femmine">Isola delle Femmine</option>
                            <option value="Lascari">Lascari</option>
                            <option value="Lercara Friddi">Lercara Friddi</option>
                            <option value="Marineo">Marineo</option>
                            <option value="Mezzojuso">Mezzojuso</option>
                            <option value="Misilmeri">Misilmeri</option>
                            <option value="Monreale">Monreale</option>
                            <option value="Montelepre">Montelepre</option>
                            <option value="Montemaggiore Belsito">Montemaggiore Belsito</option>
                            <option value="Palazzo Adriano">Palazzo Adriano</option>
                            <option value="Palermo">Palermo</option>
                            <option value="Partinico">Partinico</option>
                            <option value="Petralia Soprana">Petralia Soprana</option>
                            <option value="Petralia Sottana">Petralia Sottana</option>
                            <option value="Piana degli Albanesi">Piana degli Albanesi</option>
                            <option value="Polizzi Generosa">Polizzi Generosa</option>
                            <option value="Pollina">Pollina</option>
                            <option value="Prizzi">Prizzi</option>
                            <option value="Roccamena">Roccamena</option>
                            <option value="Roccapalumba">Roccapalumba</option>
                            <option value="San Cipirello">San Cipirello</option>
                            <option value="San Giuseppe Jato">San Giuseppe Jato</option>
                            <option value="San Mauro Castelverde">San Mauro Castelverde</option>
                            <option value="Santa Cristina Gela">Santa Cristina Gela</option>
                            <option value="Santa Flavia">Santa Flavia</option>
                            <option value="Sciara">Sciara</option>
                            <option value="Scillato">Scillato</option>
                            <option value="Sclafani Bagni">Sclafani Bagni</option>
                            <option value="Termini Imerese">Termini Imerese</option>
                            <option value="Terrasini">Terrasini</option>
                            <option value="Torretta">Torretta</option>
                            <option value="Trabia">Trabia</option>
                            <option value="Trappeto">Trappeto</option>
                            <option value="Ustica">Ustica</option>
                            <option value="Valledolmo">Valledolmo</option>
                            <option value="Ventimiglia di Sicilia">Ventimiglia di Sicilia</option>
                            <option value="Vicari">Vicari</option>
                            <option value="Villabate">Villabate</option>
                            <option value="Villafrati">Villafrati</option>`;
    var option_rg   =      `<option value="Acate">Acate</option>
                            <option value="Chiaramonte Gulfi">Chiaramonte Gulfi</option>
                            <option value="Comiso">Comiso</option>
                            <option value="Giarratana">Giarratana</option>
                            <option value="Ispica">Ispica</option>
                            <option value="Modica">Modica</option>
                            <option value="Monterosso Almo">Monterosso Almo</option>
                            <option value="Pozzallo">Pozzallo</option>
                            <option value="Ragusa">Ragusa</option>
                            <option value="Santa Croce Camerina">Santa Croce Camerina</option>
                            <option value="Scicli">Scicli</option>
                            <option value="Vittoria">Vittoria</option>`;
    var option_sr   =      `<option value="Augusta">Augusta</option>
                            <option value="Avola">Avola</option>
                            <option value="Buccheri">Buccheri</option>
                            <option value="Buscemi">Buscemi</option>
                            <option value="Canicattini Bagni">Canicattini Bagni</option>
                            <option value="Carlentini">Carlentini</option>
                            <option value="Cassaro">Cassaro</option>
                            <option value="Ferla">Ferla</option>
                            <option value="Floridia">Floridia</option>
                            <option value="Francofonte">Francofonte</option>
                            <option value="Lentini">Lentini</option>
                            <option value="Melilli">Melilli</option>
                            <option value="Noto">Noto</option>
                            <option value="Pachino">Pachino</option>
                            <option value="Palazzolo Acreide">Palazzolo Acreide</option>
                            <option value="Priolo Gargallo">Priolo Gargallo</option>
                            <option value="Rosolini">Rosolini</option>
                            <option value="Siracusa">Siracusa</option>
                            <option value="Solarino">Solarino</option>
                            <option value="Sortino">Sortino</option>
                            <option value="Portopalo di Capo Passero">Portopalo di Capo Passero</option>`;
    var option_tp   =      `<option value="Alcamo">Alcamo</option>
                            <option value="Buseto Palizzolo">Buseto Palizzolo</option>
                            <option value="Calatafimi-Segesta">Calatafimi-Segesta</option>
                            <option value="Campobello di Mazara">Campobello di Mazara</option>
                            <option value="Castellammare del Golfo">Castellammare del Golfo</option>
                            <option value="Castelvetrano">Castelvetrano</option>
                            <option value="Custonaci">Custonaci</option>
                            <option value="Erice">Erice</option>
                            <option value="Favignana">Favignana</option>
                            <option value="Gibellina">Gibellina</option>
                            <option value="Marsala">Marsala</option>
                            <option value="Mazara del Vallo">Mazara del Vallo</option>
                            <option value="Misiliscemi">Misiliscemi</option>
                            <option value="Paceco">Paceco</option>
                            <option value="Pantelleria">Pantelleria</option>
                            <option value="Partanna">Partanna</option>
                            <option value="Petrosino">Petrosino</option>
                            <option value="Poggioreale">Poggioreale</option>
                            <option value="Salaparuta">Salaparuta</option>
                            <option value="Salemi">Salemi</option>
                            <option value="San Vito Lo Capo">San Vito Lo Capo</option>
                            <option value="Santa Ninfa">Santa Ninfa</option>
                            <option value="Trapani">Trapani</option>
                            <option value="Valderice">Valderice</option>
                            <option value="Vita">Vita</option>`;
    switch (provincia) {
        case 'ag':
            return option_ag;
            break;
        case 'cl':
            return option_cl;
            break;
        case 'ct':
            return option_ct;
            break;
        case 'en':
            return option_en;
            break;
        case 'me':
            return option_me;
            break;
        case 'pa':
            return option_pa;
            break;
        case 'rg':
            return option_rg;
            break;
        case 'sr':
            return option_sr;
            break;
        case 'tp':
            return option_tp;
            break;
        default:
            break;
    }
}

function crea_localizzazione_investimento(numero_di_localizzazioni, numero_localizzazioni_precedenti){
    var accordion_localizzazioni = "";
    var numero_localizzazioni_da_cui_iniziare = 1;
    if(numero_di_localizzazioni > numero_localizzazioni_precedenti)
    {
        numero_localizzazioni_da_cui_iniziare = numero_localizzazioni_precedenti*1 + 1;
        for (var i = numero_localizzazioni_da_cui_iniziare; i <= numero_di_localizzazioni; i++) {
            accordion_localizzazioni += `
                <div class="accordion-item" name="localizzazione-investimento_${i}" id="localizzazione-investimento_${i}">
                  <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                      data-bs-target="#collapse-${i}" aria-expanded="false" aria-controls="#collapse-${i}">
                      Localizzazione Investimento n.<span class="numero_localizzazione_investimento_${i}">${i}</span>
                      <span id="validazione_localizzazione_investimento_${i}"></span>
                    </button>
                  </h2>
                  <div id="collapse-${i}" class="accordion-collapse collapse" data-bs-parent="#accordionLocalizzazioni">
                    <div class="accordion-body">
                      <div class="row">
                        <div class="col-6 mb-2">
                          <label class="form-label" for="comune-localizzazione_${i}">Comune di localizzazione
                            <span class="text-red">*</span></label>
                          <select class="form-control" name="comune-localizzazione_${i}" id="comune-localizzazione_${i}" disabled>
                          </select>
                          <div class="" id="errore_comune_localizzazione_${i}"></div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-6 mb-2">
                          <label class="form-label" for="foglio_${i}">Foglio <span class="text-red">*</span></label>
                          <input type="text" class="form-control" name="foglio_${i}"
                            placeholder="Inserisci il foglio presente sui dati catastali" id="foglio_${i}" required />
                          <div class="" id="errore_foglio_${i}"></div>
                        </div>
                        <div class="col-6 mb-2">
                          <label class="form-label" for="particella_${i}">Particelle <span class="text-red">*</span></label>
                          <input type="text" class="form-control" name="particelle_${i}"
                            placeholder="Inserisci la/le particella/e presenti sui dati catastali separate da virgola" id="particella_${i}" required />
                          <div class="" id="errore_particella_${i}"></div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>          
            `;
        }
        $("#accordion_aggiuntivi_loc").append(accordion_localizzazioni);
        abilitaEPopolaNuoviComuni(numero_localizzazioni_da_cui_iniziare, numero_di_localizzazioni);
        $("#numero_localizzazioni_investimenti").attr("data-numero-localizzazioni-prev", numero_di_localizzazioni);
    }
}
  
function rimuovi_localizzazione_investimento(numero_di_localizzazioni, numero_localizzazioni_precedenti){
    var contatore_localizzazioni = numero_di_localizzazioni*1 + 1;
    for(var i = contatore_localizzazioni; i <= numero_localizzazioni_precedenti; i++){
        $("#localizzazione-investimento_"+i).remove();
    }
    $("#numero_localizzazioni_investimenti").attr("data-numero-localizzazioni-prev", numero_di_localizzazioni);
}

function abilitaEPopolaNuoviComuni(from, to) {
  const prov = $("#provincia-localizzazione").val();
  const html = prov ? appendi_select_comuni(prov) : "";
  for (let i = from; i <= to; i++) {
    const $sel = $(`#comune-localizzazione_${i}`);
    if (!$sel.length) continue;
    if (prov) {
      $sel.prop("disabled", false)
          .removeClass("is-invalid")
          .html(html)
          .val("");
      $(`#errore_comune_localizzazione_${i}`).removeClass("invalid-feedback").text("");
    } else {
      $sel.prop("disabled", true).html("");
    }
  }
}
